/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.text;

import java.util.List;
import java.util.stream.Collectors;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.platform.sources.PlatformSource;
import net.impactdev.impactor.api.utility.Context;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TextProcessor {
    public static TextProcessor mini() {
        return Impactor.instance().factories().provide(Factory.class).mini();
    }

    public static TextProcessor mini(MiniMessage delegate) {
        return Impactor.instance().factories().provide(Factory.class).mini(delegate);
    }

    public static TextProcessor legacy(char character) {
        return Impactor.instance().factories().provide(Factory.class).legacy(character);
    }

    @NotNull
    default public Component parse(String raw) {
        return this.parse(null, raw, Context.empty());
    }

    @NotNull
    default public Component parse(@Nullable PlatformSource viewer, String raw) {
        return this.parse(viewer, raw, Context.empty());
    }

    @NotNull
    default public Component parse(String raw, Context context) {
        return this.parse(null, raw, context);
    }

    @NotNull
    public Component parse(@Nullable PlatformSource var1, String var2, Context var3);

    default public List<@NotNull Component> parse(List<String> raw) {
        return this.parse(null, raw, Context.empty());
    }

    default public List<@NotNull Component> parse(@Nullable PlatformSource viewer, List<String> raw) {
        return this.parse(viewer, raw, Context.empty());
    }

    default public List<@NotNull Component> parse(List<String> raw, Context context) {
        return this.parse(null, raw, context);
    }

    default public List<@NotNull Component> parse(@Nullable PlatformSource viewer, List<String> raw, Context context) {
        return raw.stream().map(input -> this.parse(viewer, (String)input, context)).collect(Collectors.toList());
    }

    public static interface Factory {
        public TextProcessor mini();

        public TextProcessor mini(MiniMessage var1);

        public TextProcessor legacy(char var1);
    }
}

